package fr.asip.cps3.exemple.vues.ecrans.saisie;

import javax.swing.JButton;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.ecrans.Ecran;

/**
 * Classe abstraite reprsentant un cran de saisie par l'utilisateur
 */
public abstract class Saisie extends Ecran {

	/**
	 * Bouton de soumission du formulaire
	 */
	protected JButton soumettre;	
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 */
	public Saisie(FenetrePrincipale fenetre,int typeEcran) {		
		super(fenetre);
		setType(typeEcran);
    	soumettre = new JButton("Soumettre");
    	soumettre.addActionListener(fenetre);
	}
}
